using System;
using System.IO;
using System.Net;
using System.Text;
using System.Collections.Generic;
using System.Web.Script.Serialization;


public class NeoAPIOAuth_4 {

    static public void Main () {        

        String access_token = "YOUR_ACCESS_TOKEN";
        String upload_leads_url = "https://api.sandbox.neoogilvy.com/siteserve/siteserve"; // for production, use https://api.neoogilvy.com/siteserve/siteserve
        
        // represent individual leads to be uploaded as a dict
        Dictionary<string, string> lead_1 = new Dictionary<string, string>(){
            {"campaign_id","163051"},
            {"campaign_name","2010 Q4|IBM_Non-CA_IT_RationalCS|NonIntel|NYC|USA"},
            {"publisher_id","I/EMEDIA (00104221)"},
            {"placement_name","AVIATION WEEK|Systems - Content Syndication|0x0"},
            {"isource","isource"},
            {"io_number","iordnum"},
            {"title","Mr"},
            {"first_name","John"},
            {"middle_name","middle name"},
            {"last_name","Smith"},
            {"job_title","job title"},
            {"company","Acne Corporation"},
            {"company_size","company size"},
            {"address_line_1","address line 1"},
            {"address_line_2","address line 2"},
            {"address_line_3","address line 3"},
            {"city","New York City"},
            {"state","New York"},
            {"zip_code","10021"},
            {"country","US"},
            {"phone","9876543210"},
            {"fax","9876543211"},
            {"ctdochk","ctdochk"},
            {"email","john.smith@company.com"},
            {"tsrecv","tsrecv"},
            {"nextension","extension number"},
            {"department","department name"},
            {"geography","cgeography"},
            {"us_score","usscore"},
            {"ww_score","wwscore"},
            {"iadmid","iadmid"},
            {"custinfo1","customer info 1"},
            {"custinfo2","customer info 2"},
            {"privacy","cprivacy"},
            {"icampaign","icampaign"},
            {"tactic","ttactic"},
            {"response_type","resptype"},
            {"asset_name","assetname"},
            {"question_1","question 1"},
            {"answer_1","answer 1"},
            {"question_2","question 2"},
            {"answer_2","answer 2"},
            {"question_3","question 3"},
            {"answer_3","answer 3"},
            {"timestamp","timestamp"},
            {"source_site","company.com"},
            {"questionnum1_ooemail","question 1"},
            {"questionnum2_ootele","question 2"},
            {"questionnum3_oopostal","question 3"},
            {"answer1_ooemail","answer 1"},
            {"answer2_ootele","answer 2"},
            {"answer3_oopostal","answer 3"},
            {"email_verification","yes"},
            {"phone_verification","yes"},
            {"zipcode_verification","yes"},
            {"unique_order_number","UON1234"},
            {"offer_code","10000638"},
            {"channel","Digital Inbound:Content Syndication"},
            {"interaction_type","CONTSYND"}
        };

        // Create More leads...
        // Dictionary<string, string> lead_2 = new Dictionary<string, string>(){}...
        // Dictionary<string, string> lead_2 = new Dictionary<string, string>(){}...
        // Dictionary<string, string> lead_4 = new Dictionary<string, string>(){}...

        // Create a list to contain dicts of leads
        List<Dictionary<string, string>> LeadsList= new List<Dictionary<string, string>>();
        
        // Add leads to the list
        LeadsList.Add(lead_1);
        
        // LeadsList.Add(lead_2);
        // LeadsList.Add(lead_3);
        // LeadsList.Add(lead_4);...

        // build and assign body text to the POST request
        string body = new JavaScriptSerializer().Serialize(LeadsList);
        var requestBody = Encoding.UTF8.GetBytes(body);

        // initialize the POST request
        var request = (HttpWebRequest)WebRequest.Create(upload_leads_url);
        request.Method = "POST";
        request.ContentLength = requestBody.Length;
        request.ContentType = "application/json";
        request.Headers.Add("Authorization", "Bearer " + access_token);
        request.Accept = "application/json" ;

        string output = string.Empty;
        try  {
            using (var requestStream = request.GetRequestStream()) {
                requestStream.Write(requestBody, 0, requestBody.Length);
            }

            // perform the POST request 
            using (var response = request.GetResponse()) {
                using (var stream = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding(1252))) {
                    output = stream.ReadToEnd();

                    // parse the response json and show desired outputs
                    dynamic responseJSONDict = new JavaScriptSerializer().DeserializeObject(output);
                    Console.WriteLine("Request ID : " + responseJSONDict["response"]["request_id"]);

                    // total submitted leads should be EQUAL to sum of uploaded leads, duplicate leads and invalid leads
                    var total_leads = (Int64)responseJSONDict["response"]["total_leads"];
                    var uploaded_leads = (Int64)responseJSONDict["response"]["uploaded_leads"];
                    var duplicate_leads = (Int64)responseJSONDict["response"]["duplicate_leads"];
                    var invalid_leads = (Int64)responseJSONDict["response"]["invalid_leads"];

                    if( total_leads != (uploaded_leads + duplicate_leads + invalid_leads)) {
                        Console.WriteLine("ERROR :: Total submitted leads is NOT equal to sum of uploaded, duplicate and invalid leads.");
                    };

                    if (responseJSONDict["response"]["status"] == "Failed") {
                        Console.WriteLine("Lead upload failed because of the following error(s) : " + new JavaScriptSerializer().Serialize(responseJSONDict["response"]["errors"]));
                    } else {
                        Console.WriteLine("All leads were uploaded successfully.");
                    };
                }
            }
        } catch (WebException ex) {
            Console.WriteLine("Oops ! Something went wrong :: " + ex.Message);
            var resp = new StreamReader(ex.Response.GetResponseStream()).ReadToEnd();
            Console.WriteLine(resp);
        }
    }

}
