using System;
using System.IO;
using System.Net;
using System.Text;
using System.Collections.Generic;
using System.Web.Script.Serialization;


public class NeoAPIOAuth_5 {

    static public void Main () {        

        // define access_token, request_id, status_request_url
        String access_token = "YOUR_ACCESS_TOKEN";
        String request_id = "REQUEST_ID_TO_QUERY";
        String status_request_url = "https://api.sandbox.neoogilvy.com/siteserve/status/"; // for production, use https://api.neoogilvy.com/siteserve/status/

        // initialize the GET request
        var request = (HttpWebRequest)WebRequest.Create(status_request_url + request_id);
        request.Method = "GET";
        request.Headers.Add("Authorization", "Bearer " + access_token);
        request.Accept = "application/json" ;

        string output = string.Empty;
        try {

            // perform the GET request 
            using (var response = request.GetResponse()) {
                using (var stream = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding(1252))) {
                    output = stream.ReadToEnd();

                    // parse the response json
                    dynamic responseJSONDict = new JavaScriptSerializer().DeserializeObject(output);
                    Console.WriteLine("Request ID : " + responseJSONDict["request_id"]);
                    Console.WriteLine("This request was submitted on : " + responseJSONDict["created_date"]);

                    // total submitted leads should be EQUAL to sum of uploaded leads, duplicate leads and invalid leads
                    var total_leads = (Int64)responseJSONDict["response"]["total_leads"];
                    var uploaded_leads = (Int64)responseJSONDict["response"]["uploaded_leads"];
                    var duplicate_leads = (Int64)responseJSONDict["response"]["duplicate_leads"];
                    var invalid_leads = (Int64)responseJSONDict["response"]["invalid_leads"];

                    if( total_leads != (uploaded_leads + duplicate_leads + invalid_leads)) {
                        Console.WriteLine("ERROR :: Total submitted leads is NOT equal to sum of uploaded, duplicate and invalid leads.");
                    };

                    if (responseJSONDict["response"]["status"] == "Failed") {
                        Console.WriteLine("Lead upload failed because of the following error(s) : " + new JavaScriptSerializer().Serialize(responseJSONDict["response"]["errors"]));
                    } else {
                        Console.WriteLine("All leads were uploaded successfully.");
                    };
                }
            }
        } catch (WebException ex) {
            Console.WriteLine("Oops ! Something went wrong :: " + ex.Message);
            var resp = new StreamReader(ex.Response.GetResponseStream()).ReadToEnd();
            Console.WriteLine(resp);
        }
    }
}