using System;
using System.IO;
using System.Net;
using System.Text;
using System.Collections.Generic;
using System.Web.Script.Serialization;


// Credentials and other params for Post request's body
public class PostData {
    public string client_id = "YOUR_CLIENT_ID";
    public string client_secret = "YOUR_CLIENT_SECRET";
    public string refresh_token = "YOUR_REFRESH_TOKEN";
    public string grant_type = "refresh_token";
}


public class NeoAPIOAuth_3 {

    static public void Main () {

        String refresh_access_token_url = "https://api.sandbox.neoogilvy.com/oauth"; // for production, use https://api.neoogilvy.com/oauth

        // initialize the POST request
        var request = (HttpWebRequest)WebRequest.Create(refresh_access_token_url);
        request.Method = "POST";
        
        // build and assign body text to the POST request
        string body = new JavaScriptSerializer().Serialize(new PostData());

        var requestBody = Encoding.UTF8.GetBytes(body);
        request.ContentLength = requestBody.Length;
        request.ContentType = "application/json";

        string output = string.Empty;
        try  {
            using (var requestStream = request.GetRequestStream()) {
                requestStream.Write(requestBody, 0, requestBody.Length);
            }

            // perform the POST request
            using (var response = request.GetResponse()) {
                using (var stream = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding(1252))) {
                    output = stream.ReadToEnd();

                    // parse json response
                    Dictionary<string, string> responseJSONDict = new JavaScriptSerializer().Deserialize<Dictionary<string, string>>(output);
                    Console.WriteLine("Refreshed Access token : " + responseJSONDict["access_token"]);
                }
            }
        } catch (WebException ex) {
            Console.WriteLine("Oops ! Something went wrong :: " + ex.Message);
        }
    }   
}