using System;
using System.IO;
using System.Net;
using System.Text;
using System.Collections.Generic;
using System.Web.Script.Serialization;


// Credentials and other params for Post request's body
public class PostData {
    public string redirect_uri = "/oauth/receivecode";
    public string client_id = "YOUR_CLIENT_ID";
    public string client_secret = "YOUR_CLIENT_SECRET";
    public string code = "AUTHORIZATION_CODE_GENERATED_BY SYSTEM";
    public string grant_type = "authorization_code";
}


public class NeoAPIOAuth_2 {
    
    static public void Main () {

        String access_token_generate_url = "https://api.sandbox.neoogilvy.com/oauth"; // for production, use https://api.neoogilvy.com/oauth

        // initialize the POST request
        var request = (HttpWebRequest)WebRequest.Create(access_token_generate_url);
        request.Method = "POST";

        // build and assign body text to the POST request
        string body = new JavaScriptSerializer().Serialize(new PostData());

        var requestBody = Encoding.UTF8.GetBytes(body);
        request.ContentLength = requestBody.Length;
        request.ContentType = "application/json";

        string output = string.Empty;
        try {
            using (var requestStream = request.GetRequestStream()) {
                requestStream.Write(requestBody, 0, requestBody.Length);
            }

            // perform the POST request
            using (var response = request.GetResponse()) {
                using (var stream = new StreamReader(response.GetResponseStream(), Encoding.GetEncoding(1252))) {

                    // get the response output
                    output = stream.ReadToEnd();

                    // parse json response
                    Dictionary<string, string> responseJSONDict = new JavaScriptSerializer().Deserialize<Dictionary<string, string>>(output);
                    Console.WriteLine("Access token : " + responseJSONDict["access_token"]);
                    Console.WriteLine("Refresh token : " + responseJSONDict["refresh_token"]);
                }
            }
        } catch (WebException ex) {
            Console.WriteLine("Oops ! Something went wrong :: " + ex.Message);
        }
    }   
}